/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.source.scanner;

import java.util.regex.Pattern;
import org.sterling.SterlingException;
import org.sterling.source.scanner.InputReader;
import org.sterling.source.scanner.ScannerDelegate;
import org.sterling.source.scanner.ScannerUtil;
import org.sterling.source.syntax.DoubleToken;
import org.sterling.source.syntax.NodeKind;
import org.sterling.source.syntax.Token;

public class DoubleScanner
implements ScannerDelegate {
    private final Pattern pattern = Pattern.compile("^(?:0(?!\\d)|[1-9][0-9]*)?\\.[\\d]+");

    @Override
    public boolean expect(NodeKind kind, InputReader reader) {
        return reader.expect(this.pattern);
    }

    @Override
    public Token require(NodeKind kind, InputReader reader) throws SterlingException {
        if (reader.store(this.pattern)) {
            Token token = reader.accept(kind);
            return new DoubleToken(token, Double.parseDouble(token.getValue()));
        }
        throw ScannerUtil.unexpectedInput(reader, kind);
    }
}

