/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.source.scanner;

import java.util.ArrayDeque;
import java.util.Deque;

class StateManager<T> {
    private final Deque<T> inputState;
    private final Deque<Deque<T>> states;

    public StateManager(Deque<T> inputState) {
        this.inputState = inputState;
        this.states = new ArrayDeque<Deque<T>>();
    }

    public void begin() {
        this.states.push(new ArrayDeque());
    }

    public void close() {
        while (!this.states.isEmpty()) {
            this.states.pop();
        }
    }

    public void end() {
        if (this.states.isEmpty()) {
            throw new IllegalStateException();
        }
        this.states.pop();
    }

    public void push(T reference) {
        for (Deque<T> transaction : this.states) {
            transaction.push(reference);
        }
    }

    public void restore() {
        if (this.states.isEmpty()) {
            throw new IllegalStateException();
        }
        Deque<T> transaction = this.states.pop();
        while (transaction.size() > 0) {
            this.inputState.push(transaction.pop());
        }
    }
}

