/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.source.scanner;

import java.util.regex.Pattern;
import org.sterling.SterlingException;
import org.sterling.source.scanner.EscapeUtil;
import org.sterling.source.scanner.InputReader;
import org.sterling.source.scanner.ScannerDelegate;
import org.sterling.source.scanner.ScannerUtil;
import org.sterling.source.syntax.NodeKind;
import org.sterling.source.syntax.StringToken;
import org.sterling.source.syntax.Token;

public class StringScanner
implements ScannerDelegate {
    private final Pattern asciiEscape = Pattern.compile("^\\\\[btnfr\"'\\\\]");
    private final Pattern hexEscape = Pattern.compile("^\\\\u[a-fA-F0-9]{4}");
    private final Pattern octalEscape = Pattern.compile("^\\\\([0-3][0-7]{2}|[0-7]{1,2})");

    @Override
    public boolean expect(NodeKind kind, InputReader reader) {
        return reader.expect('\"');
    }

    @Override
    public Token require(NodeKind kind, InputReader reader) throws SterlingException {
        if (!this.expect(kind, reader)) {
            throw ScannerUtil.unexpectedInput(reader, kind);
        }
        reader.store();
        while (!reader.expect('\"')) {
            this.storeInput(kind, reader);
        }
        reader.store();
        Token token = reader.accept(kind);
        return new StringToken(token, EscapeUtil.unescapeString(token.getValue().substring(1, token.getValue().length() - 1)));
    }

    private void storeInput(NodeKind kind, InputReader reader) throws SterlingException {
        if (!reader.store(this.asciiEscape, this.hexEscape, this.octalEscape)) {
            if (reader.expect('\\')) {
                throw ScannerUtil.invalidEscapeSequence(reader, kind);
            }
            if (reader.expect('\n')) {
                throw ScannerUtil.unterminatedString(reader, kind);
            }
            reader.store();
        }
    }
}

