/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.source.translator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ModuleBuilder {
    private State state = new BuildState();

    public void acceptModule() {
        this.state = new AcceptState(this.state.getModule());
    }

    public void appendModule(String part) {
        this.state.appendModule(part);
    }

    public String getIdentifier() {
        return this.state.getModule();
    }

    public boolean isDeclared() {
        return this.state.isDeclared();
    }

    private static final class BuildState
    implements State {
        private final List<String> parts = new ArrayList<String>();

        @Override
        public void appendModule(String modulePart) {
            this.parts.add(modulePart);
        }

        @Override
        public boolean isDeclared() {
            return false;
        }

        @Override
        public String getModule() {
            StringBuilder builder = new StringBuilder();
            Iterator<String> iterator = this.parts.iterator();
            if (iterator.hasNext()) {
                builder.append(iterator.next());
                while (iterator.hasNext()) {
                    builder.append('/');
                    builder.append(iterator.next());
                }
            }
            return builder.toString();
        }
    }

    private static final class AcceptState
    implements State {
        private final String module;

        public AcceptState(String module) {
            this.module = module;
        }

        @Override
        public void appendModule(String modulePart) {
            throw new IllegalStateException();
        }

        @Override
        public boolean isDeclared() {
            return true;
        }

        @Override
        public String getModule() {
            return this.module;
        }
    }

    private static interface State {
        public void appendModule(String var1);

        public boolean isDeclared();

        public String getModule();
    }
}

