/*
 * Decompiled with CFR 0.152.
 */
package org.stokesdrift.moka;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.stokesdrift.moka.collections.PropertyDelegateMap;
import org.stokesdrift.moka.util.PropertyUtil;

public class Configuration
extends PropertyDelegateMap {
    private static final Logger logger = Logger.getLogger(Configuration.class.getName());
    private String prefix;
    private List<String> loadPathDirectories;
    private Properties combinedProperties;

    public Configuration() {
    }

    public Configuration(String prefix) {
        this.prefix = prefix;
    }

    public void addLoadPath(String directory) {
        if (this.loadPathDirectories == null) {
            this.loadPathDirectories = new ArrayList<String>();
        }
        this.loadPathDirectories.add(directory);
    }

    public void loadProperties() {
        this.combinedProperties = null;
        for (String dir : this.loadPathDirectories) {
            try {
                this.combinedProperties = PropertyUtil.loadPropertyFile(this.prefix, dir, this.combinedProperties);
            }
            catch (Exception e) {
                StringBuilder logMsg = new StringBuilder("Not able to load ");
                if (this.prefix != null) {
                    logMsg.append(this.prefix);
                }
                logMsg.append(" from directory ").append(dir);
                logger.log(Level.WARNING, logMsg.toString(), e);
            }
        }
    }

    public void init() {
        this.loadProperties();
        if (this.combinedProperties == null) {
            this.combinedProperties = new Properties();
        }
        Properties systemProperties = System.getProperties();
        Set<String> propertyNames = this.combinedProperties.stringPropertyNames();
        for (String key : propertyNames) {
            String value = systemProperties.getProperty(key);
            if (System.getenv(this.convertToEnvKey(key)) != null) {
                value = System.getenv(this.convertToEnvKey(key));
            }
            if (value == null) continue;
            this.combinedProperties.setProperty(key, value);
        }
        this.setDelegateMap(this.combinedProperties);
    }

    protected String convertToEnvKey(String key) {
        String name = key;
        name = name.replaceAll("\\.", "_");
        return name.toUpperCase();
    }

    public Integer getInteger(String key) {
        Integer i = -1;
        Object obj = this.get(key);
        if (obj != null) {
            i = obj instanceof Integer ? (Integer)obj : Integer.valueOf(obj.toString());
        }
        return i;
    }

    public String getString(String key) {
        String value = null;
        Object obj = this.get(key);
        if (obj != null) {
            value = obj.toString();
        }
        return value;
    }

    public String[] getStringArray(String key) {
        String value = null;
        Object obj = this.get(key);
        if (obj != null) {
            value = obj.toString();
        }
        if (value != null) {
            return value.split(",");
        }
        return null;
    }
}

