/*
 * Decompiled with CFR 0.152.
 */
package org.storynode.pigeon.assertion;

import java.util.function.Function;
import org.assertj.core.api.AbstractAssert;
import org.jetbrains.annotations.NotNull;
import org.storynode.pigeon.option.Option;

public class OptionAssert<T>
extends AbstractAssert<OptionAssert<T>, Option<T>> {
    public OptionAssert(Option<T> actual) {
        super(actual, OptionAssert.class);
    }

    public OptionAssert<T> isSome() {
        return this.isNotEmpty();
    }

    public OptionAssert<T> isNone() {
        return this.isEmpty();
    }

    public OptionAssert<T> isEmpty() {
        this.isNotNull();
        if (((Option)this.actual).isSome()) {
            this.failWithMessage("Expected to be None but was Some(%s)", new Object[]{((Option)this.actual).unwrap()});
        }
        return this;
    }

    public OptionAssert<T> isNotEmpty() {
        this.isNotNull();
        if (((Option)this.actual).isNone()) {
            this.failWithMessage("Expected to be Some but was None", new Object[0]);
        }
        return this;
    }

    public <U> OptionAssert<T> returns(U expected, @NotNull Function<Option<T>, U> provider) {
        U ret = provider.apply((Option)this.actual);
        if (!ret.equals(expected)) {
            this.failWithMessage("Comparison failed: expected %s but got %s", new Object[]{expected, ret});
        }
        return this;
    }
}

