/*
 * Decompiled with CFR 0.152.
 */
package org.storynode.pigeon.assertion;

import java.util.function.Function;
import org.assertj.core.api.AbstractAssert;
import org.jetbrains.annotations.NotNull;
import org.storynode.pigeon.result.Result;

public class ResultAssert<T, E>
extends AbstractAssert<ResultAssert<T, E>, Result<T, E>> {
    public ResultAssert(Result<T, E> teResult) {
        super(teResult, ResultAssert.class);
    }

    public ResultAssert<T, E> isOk() {
        this.isNotNull();
        if (!((Result)this.actual).isOk()) {
            this.failWithMessage("Expected to be Ok() but was Err(%s)", new Object[]{((Result)this.actual).unwrapError()});
        }
        return this;
    }

    public ResultAssert<T, E> unwraps(T value) {
        this.isNotNull();
        this.isOk();
        if (!((Result)this.actual).unwrap().equals(value)) {
            this.failWithMessage("Expected unwrapped value to be %s but was %s", new Object[]{value, ((Result)this.actual).unwrap()});
        }
        return this;
    }

    public ResultAssert<T, E> isError() {
        this.isNotNull();
        if (!((Result)this.actual).isErr()) {
            this.failWithMessage("Expected to be Err() but was %s", new Object[]{this.actual});
        }
        return this;
    }

    public <U> ResultAssert<T, E> returns(U expected, @NotNull Function<Result<T, E>, U> provider) {
        U ret = provider.apply((Result)this.actual);
        if (!ret.equals(expected)) {
            this.failWithMessage("Comparison failed: expected %s but got %s", new Object[]{expected, ret});
        }
        return this;
    }
}

