/*
 * Decompiled with CFR 0.152.
 */
package org.storynode.pigeon.option;

import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.storynode.pigeon.option.None;
import org.storynode.pigeon.option.Some;
import org.storynode.pigeon.protocol.SafelyWrapped;

public abstract class Option<T>
implements SafelyWrapped<T> {
    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T> Option<T> some(@NotNull T value) {
        return Option.of(value);
    }

    @NotNull
    public static <T> Option<T> of(T value) {
        if (value == null) {
            return Option.none();
        }
        return new Some<T>(value);
    }

    @NotNull
    public static <T> Option<T> of(@NotNull Supplier<T> valueSupplier) {
        return Option.of(valueSupplier.get());
    }

    @NotNull
    public static <T> None<T> none() {
        return (None)None.INSTANCE;
    }

    public abstract boolean isSome();

    public boolean isNone() {
        return !this.isSome();
    }

    public abstract void ifPresent(Consumer<T> var1);

    public abstract void ifPresentOrElse(Consumer<T> var1, Runnable var2);

    public abstract Option<T> filter(Predicate<? super T> var1);

    public abstract <U> Option<U> map(@NotNull Function<T, U> var1);

    public abstract <U> Option<U> flatMap(Function<? super T, ? extends Option<? extends U>> var1);

    public abstract Option<? extends T> or(@NotNull Supplier<? extends Option<? extends T>> var1);

    public abstract T orElseGet(@NotNull Supplier<T> var1);

    public abstract T orElse(T var1);

    public abstract T orElseThrow() throws NoSuchElementException;

    public abstract <E extends Throwable> T orElseThrow(@NotNull Supplier<E> var1) throws E;

    public abstract Stream<T> stream();
}

