/*
 * Decompiled with CFR 0.152.
 */
package org.storynode.pigeon.option;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;
import org.storynode.pigeon.option.Option;

public class Some<T>
extends Option<T> {
    private final T value;

    protected Some(@NonNull T value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.value = value;
    }

    @Override
    public boolean isSome() {
        return true;
    }

    @Override
    public void ifPresent(@NotNull Consumer<T> func) {
        if (func == null) {
            Some.$$$reportNull$$$0(0);
        }
        func.accept(this.unwrap());
    }

    @Override
    public void ifPresentOrElse(@NotNull Consumer<T> whenPresent, Runnable otherwise) {
        if (whenPresent == null) {
            Some.$$$reportNull$$$0(1);
        }
        whenPresent.accept(this.unwrap());
    }

    @Override
    public Option<T> filter(Predicate<? super T> predicate) {
        return predicate.test(this.value) ? this : Some.none();
    }

    @Override
    public <U> Option<U> map(@NotNull Function<T, U> mapper) {
        if (mapper == null) {
            Some.$$$reportNull$$$0(2);
        }
        return Option.some(mapper.apply(this.value));
    }

    @Override
    public <U> Option<U> flatMap(@NotNull Function<? super T, ? extends Option<? extends U>> mapper) {
        if (mapper == null) {
            Some.$$$reportNull$$$0(3);
        }
        return mapper.apply(this.value);
    }

    @Override
    public Option<? extends T> or(@NotNull Supplier<? extends Option<? extends T>> supplier) {
        if (supplier == null) {
            Some.$$$reportNull$$$0(4);
        }
        return this;
    }

    @Override
    public T orElseGet(@NotNull Supplier<T> supplier) {
        if (supplier == null) {
            Some.$$$reportNull$$$0(5);
        }
        return this.unwrap();
    }

    @Override
    public T orElse(T other) {
        return this.unwrap();
    }

    @Override
    public T orElseThrow() {
        return this.value;
    }

    @Override
    public <E extends Throwable> T orElseThrow(@NotNull Supplier<E> throwable) {
        if (throwable == null) {
            Some.$$$reportNull$$$0(6);
        }
        return this.value;
    }

    @Override
    public Stream<T> stream() {
        return Stream.of(this.value);
    }

    public T value() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return Objects.equals(this.value, ((Some)obj).value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return "Some[value=" + String.valueOf(this.value) + "]";
    }

    @Override
    public T unwrap() {
        return this.value;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "func";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whenPresent";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwable";
                break;
            }
        }
        objectArray2[1] = "org/storynode/pigeon/option/Some";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "ifPresent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "ifPresentOrElse";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "map";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "flatMap";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "or";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "orElseGet";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "orElseThrow";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

