/*
 * Decompiled with CFR 0.152.
 */
package org.storynode.pigeon.protocol;

import java.util.function.BiFunction;
import java.util.function.Supplier;

@FunctionalInterface
public interface ThrowingSupplier<T>
extends Supplier<T> {
    public T getWithException() throws Exception;

    @Override
    default public T get() {
        return this.get(RuntimeException::new);
    }

    default public T get(BiFunction<String, Exception, RuntimeException> exceptionWrapper) {
        try {
            return this.getWithException();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw exceptionWrapper.apply(exception.getMessage(), exception);
        }
    }
}

