/*
 * Decompiled with CFR 0.152.
 */
package org.storynode.pigeon.result;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.storynode.pigeon.error.UnwrapException;
import org.storynode.pigeon.result.Result;

public class Err<T, E>
extends Result<T, E> {
    private final E error;

    public Err(@NotNull E error) {
        this.error = error;
    }

    @Override
    public boolean isOk() {
        return false;
    }

    @Override
    public T unwrap() throws UnwrapException {
        throw new UnwrapException("Cannot unwrap error on an Err<> value");
    }

    @Override
    public E unwrapError() {
        return this.error;
    }

    @Override
    public T orElseGet(@NotNull Supplier<T> defaultValueSupplier) {
        return defaultValueSupplier.get();
    }

    @Override
    public <U> Result<U, E> map(@NotNull Function<? super T, ? extends U> fn) {
        return Result.error(this.error);
    }

    @Override
    public <U> Result<U, E> flatMap(@NotNull Function<? super T, ? extends Result<U, E>> fn) {
        return Result.err(this.error);
    }

    @Override
    public <U> Result<T, U> mapError(@NotNull Function<? super E, ? extends U> fn) {
        return Result.error(fn.apply(this.error));
    }

    @Override
    public Result<T, E> ifOkOrElse(Consumer<T> whenOk, @NotNull Consumer<E> whenError) {
        whenError.accept(this.unwrapError());
        return this;
    }

    @Override
    public T orElse(T defaultValue) {
        return defaultValue;
    }

    @Override
    public <U> Result<U, E> and(Result<U, E> res) {
        return this;
    }

    @Override
    public <U> Result<U, E> andThen(Function<T, Result<U, E>> res) {
        return this;
    }
}

