/*
 * Decompiled with CFR 0.152.
 */
package org.storynode.pigeon.tuple;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.storynode.pigeon.option.Option;
import org.storynode.pigeon.tuple.Tuple;

public final class Pair<T1, T2>
extends Tuple {
    private final T1 first;
    private final T2 second;

    public Pair(T1 first, T2 second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public int cardinality() {
        return 2;
    }

    @Override
    @NotNull
    public Option<Object> at(int index) {
        return switch (index) {
            case 0 -> Option.of(this.first);
            case 1 -> Option.of(this.second);
            default -> Option.none();
        };
    }

    public T1 first() {
        return this.first;
    }

    public T2 second() {
        return this.second;
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second);
    }

    public String toString() {
        return "Pair[first=" + String.valueOf(this.first) + ", second=" + String.valueOf(this.second) + "]";
    }
}

