/*
 * Decompiled with CFR 0.152.
 */
package org.storynode.pigeon.tuple;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.storynode.pigeon.option.Option;
import org.storynode.pigeon.tuple.Pair;
import org.storynode.pigeon.tuple.Quartet;
import org.storynode.pigeon.tuple.Quintet;
import org.storynode.pigeon.tuple.Triplet;

public abstract class Tuple {
    @Contract(value="_, _ -> new")
    @NotNull
    public static <T1, T2> Pair<T1, T2> of(T1 first, T2 second) {
        return new Pair<T1, T2>(first, second);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static <T1, T2, T3> Triplet<T1, T2, T3> of(T1 first, T2 second, T3 third) {
        return new Triplet<T1, T2, T3>(first, second, third);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static <T1, T2, T3, T4> Quartet<T1, T2, T3, T4> of(T1 first, T2 second, T3 third, T4 fourth) {
        return new Quartet<T1, T2, T3, T4>(first, second, third, fourth);
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static <T1, T2, T3, T4, T5> Quintet<T1, T2, T3, T4, T5> of(T1 first, T2 second, T3 third, T4 fourth, T5 fifth) {
        return new Quintet<T1, T2, T3, T4, T5>(first, second, third, fourth, fifth);
    }

    abstract int cardinality();

    @NotNull
    abstract Option<Object> at(int var1);

    public Iterable<Pair<Object, Integer>> enumerate() {
        return new IterableForTuple(this);
    }

    public boolean equals(Object other) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Tuple otherTuple = (Tuple)other;
        if (this.cardinality() != otherTuple.cardinality()) {
            return false;
        }
        AtomicBoolean eq = new AtomicBoolean(true);
        for (Pair<Object, Integer> entry : this.enumerate()) {
            if (entry.first().equals(otherTuple.at(entry.second()))) continue;
            eq.set(false);
            break;
        }
        return eq.get();
    }

    private static class IterableForTuple
    implements Iterable<Pair<Object, Integer>> {
        @NotNull
        private final Tuple tuple;
        private int i = 0;

        public IterableForTuple(@NotNull Tuple tuple) {
            this.tuple = tuple;
        }

        @Override
        @NotNull
        public Iterator<Pair<Object, Integer>> iterator() {
            return new Iterator<Pair<Object, Integer>>(){

                @Override
                public boolean hasNext() {
                    return i < tuple.cardinality();
                }

                @Override
                public Pair<Object, Integer> next() {
                    Option<Object> item = tuple.at(i);
                    int index = i++;
                    return new Pair<Object, Integer>(item, index);
                }
            };
        }
    }
}

