/*
 * Decompiled with CFR 0.152.
 */
package org.storynode.pigeon.wrap;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.storynode.pigeon.function.NeverThrow;
import org.storynode.pigeon.protocol.SafelyWrapped;
import org.storynode.pigeon.protocol.Wrapped;
import org.storynode.pigeon.result.Result;
import org.storynode.pigeon.tuple.Pair;

public class Metadata<T>
implements SafelyWrapped<T> {
    private final Map<Object, Object> metadata;
    @NotNull
    private final T inner;

    @NotNull
    public static <T> Result<Metadata<T>, ? extends Throwable> from(@NotNull Wrapped<T> wrapped) {
        return Metadata.from(wrapped, Map.of());
    }

    @NotNull
    public static <T> Result<Metadata<T>, ? extends Throwable> from(@NotNull Wrapped<T> wrapped, Map<Object, Object> additionalMetadata) {
        return NeverThrow.executing(() -> {
            Map<Object, Object> metadata = new HashMap(additionalMetadata);
            if (wrapped instanceof Metadata) {
                Metadata asMetadata = (Metadata)wrapped;
                metadata.putAll(asMetadata.getMetadata());
            }
            metadata = Collections.unmodifiableMap(metadata);
            return new Metadata(wrapped.unwrap(), metadata);
        });
    }

    public Metadata(@NotNull T value) {
        this(value, Map.of());
    }

    public Metadata(@NotNull T value, Map<Object, Object> metadata) {
        this.inner = value;
        this.metadata = Map.copyOf(metadata);
    }

    @Override
    public T unwrap() {
        return this.inner;
    }

    public Pair<T, Map<Object, Object>> toTuple() {
        return Pair.of(this.unwrap(), Map.copyOf(this.getMetadata()));
    }

    @Generated
    public Map<Object, Object> getMetadata() {
        return this.metadata;
    }
}

