/**
 * Copyright (c) 2016 European Organisation for Nuclear Research (CERN), All Rights Reserved.
 */

package cern.streaming.pool.core.testing;

import cern.streaming.pool.core.service.StreamId;

public class NamedStreamId<T> implements StreamId<T> {

    private final String id;

    public NamedStreamId(String id) {
        this.id = id;
    }

    public static final <T> NamedStreamId<T> ofName(String name) {
        return new NamedStreamId<>(name);
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((id == null) ? 0 : id.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        NamedStreamId<?> other = (NamedStreamId<?>) obj;
        if (id == null) {
            if (other.id != null) {
                return false;
            }
        } else if (!id.equals(other.id)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "NamedStreamId [id=" + id + "]";
    }

}
