/**
 * Copyright (c) 2016 European Organisation for Nuclear Research (CERN), All Rights Reserved.
 */

package cern.streaming.pool.core.util;

import java.util.Collections;
import java.util.List;
import java.util.Set;

/**
 * Utility methods for collections
 */
public final class MoreCollections {

    private MoreCollections() {
        /* only static methods */
    }

    public static <T> List<T> emptyIfNull(List<T> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public static <T> Set<T> emptyIfNull(Set<T> set) {
        if (set == null) {
            return Collections.emptySet();
        }
        return set;
    }

}
