/*
 * Decompiled with CFR 0.152.
 */
package cern.streaming.pool.core.conf;

import akka.actor.ActorRefFactory;
import akka.actor.ActorSystem;
import akka.stream.ActorMaterializer;
import akka.stream.Materializer;
import cern.streaming.pool.core.service.akka.AkkaStreamFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AkkaStreamingConfiguration {
    private static final String DEFAULT_ACTOR_SYSTEM_NAME = "sys";

    @Bean(destroyMethod="terminate")
    public ActorSystem actorSystem() {
        return ActorSystem.create((String)DEFAULT_ACTOR_SYSTEM_NAME);
    }

    @Bean(destroyMethod="shutdown")
    public ActorMaterializer actorMaterializer(ActorSystem actorSystem) {
        return ActorMaterializer.create((ActorRefFactory)actorSystem);
    }

    @Bean
    public AkkaStreamFactory akkaSourceProvidingService(Materializer materializer) {
        return new AkkaStreamFactory(materializer);
    }
}

