/*
 * Decompiled with CFR 0.152.
 */
package cern.streaming.pool.core.names;

import cern.streaming.pool.core.names.ConstantsContainer;
import cern.streaming.pool.core.names.impl.ImmutableNameRepository;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class NameRepositories {
    private NameRepositories() {
    }

    public static ImmutableNameRepository newFromConstantContainers(List<ConstantsContainer> constantsContainers) {
        return new ImmutableNameRepository(NameRepositories.mapNamesFrom(constantsContainers));
    }

    private static final Map<Object, String> mapNamesFrom(List<ConstantsContainer> constantContainers) {
        return constantContainers.stream().flatMap(constants -> Stream.of(constants.getClass().getFields())).distinct().filter(NameRepositories::isPublicConstant).collect(Collectors.toMap(NameRepositories::valueOfField, NameRepositories::nameOfField));
    }

    private static final boolean isPublicConstant(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers) && Modifier.isPublic(modifiers);
    }

    private static final Object valueOfField(Field field) {
        try {
            return field.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(String.format("Cannot get the value of the field %s", field), e);
        }
    }

    private static final String nameOfField(Field field) {
        return field.getName();
    }
}

