/*
 * Decompiled with CFR 0.152.
 */
package cern.streaming.pool.core.rx.process;

import cern.streaming.pool.core.rx.process.ConcurrentCircularBuffer;
import cern.streaming.pool.core.rx.process.RunState;
import io.reactivex.Flowable;
import io.reactivex.processors.BehaviorProcessor;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class ClearableBufferProcessor<T> {
    private static final RunState DEFAULT_RUN_STATE = RunState.RUNNING;
    private static final int DEFAULT_MIN_EMIT_SIZE = 1;
    private AtomicInteger minEmitSize = new AtomicInteger(1);
    private final AtomicReference<RunState> runState = new AtomicReference<RunState>(DEFAULT_RUN_STATE);
    private BehaviorProcessor<List<T>> bufferedContent = BehaviorProcessor.create();
    private ConcurrentCircularBuffer<T> buffer = new ConcurrentCircularBuffer();

    public void setClearTrigger(Flowable<?> triggerClear) {
        triggerClear.subscribe(object -> this.buffer.clear());
    }

    public Flowable<List<T>> bufferedContent() {
        return this.bufferedContent;
    }

    public void setMinEmitSize(int minEmitSize) {
        this.minEmitSize.set(minEmitSize);
    }

    public void setBufferSize(int bufferSize) {
        this.buffer.setLength(bufferSize);
    }

    public void setBufferSize(Flowable<Integer> bufferSize) {
        bufferSize.subscribe(this.buffer::setLength);
    }

    public void setInput(Flowable<T> input) {
        input.subscribe(element -> {
            if (this.isAcquiring()) {
                this.buffer.add(element);
                this.publish();
            }
        });
    }

    private boolean isAcquiring() {
        return RunState.RUNNING.equals((Object)this.runState.get());
    }

    private void publish() {
        List<T> bufferedList = this.buffer.toList();
        if (bufferedList.size() >= this.minEmitSize.get()) {
            this.bufferedContent.onNext(bufferedList);
        }
    }

    public void setRunState(RunState runState) {
        this.runState.set(runState);
    }

    public void setRunState(Flowable<RunState> runState) {
        runState.subscribe(this.runState::set);
    }
}

