/*
 * Decompiled with CFR 0.152.
 */
package cern.streaming.pool.core.rx.process;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ConcurrentCircularBuffer<T> {
    private final AtomicLong nextIndex = new AtomicLong(0L);
    private final AtomicLong firstIndex = new AtomicLong(0L);
    private final AtomicInteger length = new AtomicInteger(1);
    private final ConcurrentHashMap<Long, T> elements = new ConcurrentHashMap();

    public void add(T value) {
        long index = this.nextIndex.getAndIncrement();
        this.elements.put(index, value);
        this.cleanup();
    }

    public void clear() {
        this.cleanUpTo(this.nextIndex.get());
    }

    private void cleanup() {
        long newFirstIndex = this.nextIndex.get() - (long)this.length.get();
        this.cleanUpTo(newFirstIndex);
    }

    private void cleanUpTo(long newFirstIndex) {
        long oldFirstIndex;
        for (long i = oldFirstIndex = this.firstIndex.getAndSet(newFirstIndex); i < newFirstIndex; ++i) {
            this.elements.remove(i);
        }
    }

    public List<T> toList() {
        ArrayList<T> list = new ArrayList<T>();
        long next = this.nextIndex.get();
        for (long i = this.firstIndex.get(); i < next; ++i) {
            T element = this.elements.get(i);
            if (element == null) continue;
            list.add(element);
        }
        return list;
    }

    public void setLength(int newLength) {
        Preconditions.checkArgument((newLength >= 0 ? 1 : 0) != 0, (Object)("buffer length must be >= 0 but was set to " + newLength));
        this.length.set(newLength);
    }
}

