/*
 * Decompiled with CFR 0.152.
 */
package cern.streaming.pool.core.service.akka;

import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.javadsl.AsPublisher;
import akka.stream.javadsl.Sink;
import akka.stream.javadsl.Source;
import cern.streaming.pool.core.service.DiscoveryService;
import cern.streaming.pool.core.service.StreamFactory;
import cern.streaming.pool.core.service.StreamId;
import cern.streaming.pool.core.service.akka.AkkaSourceProvidingService;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.reactivestreams.Publisher;

public class AkkaStreamFactory
implements AkkaSourceProvidingService,
StreamFactory {
    private final Materializer materializer;
    private final ConcurrentMap<StreamId<?>, Source<?, ?>> suppliers = new ConcurrentHashMap();

    public AkkaStreamFactory(Materializer materializer) {
        this.materializer = Objects.requireNonNull(materializer, "materializer must not be null.");
    }

    @Override
    public <T> Optional<Publisher<T>> create(StreamId<T> newId, DiscoveryService discoveryService) {
        Source source = (Source)this.suppliers.get(newId);
        if (source == null) {
            return Optional.empty();
        }
        Sink akkaSink = Sink.asPublisher((AsPublisher)AsPublisher.WITH_FANOUT);
        return Optional.of(source.runWith((Graph)akkaSink, this.materializer));
    }

    @Override
    public <T> void provide(StreamId<T> id, Source<T, ?> akkaSource) {
        Objects.requireNonNull(id, "id must not be null!");
        Objects.requireNonNull(akkaSource, "akkaSource must not be null!");
        Source<T, ?> existingSource = this.suppliers.putIfAbsent(id, akkaSource);
        if (existingSource != null) {
            throw new IllegalArgumentException("Id " + id + " already registered! Cannot register twice.");
        }
    }
}

