/*
 * Decompiled with CFR 0.152.
 */
package cern.streaming.pool.core.service.impl;

import cern.streaming.pool.core.service.StreamCreator;
import cern.streaming.pool.core.service.StreamId;
import cern.streaming.pool.core.service.impl.IdentifiedStreamCreator;
import java.util.Objects;

public class ImmutableIdentifiedStreamCreator<T>
implements IdentifiedStreamCreator<T> {
    private final StreamId<T> id;
    private final StreamCreator<T> creator;

    protected ImmutableIdentifiedStreamCreator(StreamId<T> id, StreamCreator<T> creator) {
        this.id = Objects.requireNonNull(id, "id must not be null.");
        this.creator = Objects.requireNonNull(creator, "creator must not be null.");
    }

    public static <T> IdentifiedStreamCreator<T> of(StreamId<T> id, StreamCreator<T> creator) {
        return new ImmutableIdentifiedStreamCreator<T>(id, creator);
    }

    @Override
    public StreamId<T> getId() {
        return this.id;
    }

    @Override
    public StreamCreator<T> getCreator() {
        return this.creator;
    }
}

