/*
 * Decompiled with CFR 0.152.
 */
package cern.streaming.pool.core.service.streamfactory;

import cern.streaming.pool.core.service.DiscoveryService;
import cern.streaming.pool.core.service.StreamFactory;
import cern.streaming.pool.core.service.StreamId;
import cern.streaming.pool.core.service.streamid.CombineWithLatestStreamId;
import io.reactivex.Flowable;
import java.util.Optional;
import org.reactivestreams.Publisher;

public class CombineWithLatestStreamFactory
implements StreamFactory {
    public <Y> Optional<Publisher<Y>> create(StreamId<Y> id, DiscoveryService discoveryService) {
        if (!(id instanceof CombineWithLatestStreamId)) {
            return Optional.empty();
        }
        return Optional.of(this.combineWithLatestStream((CombineWithLatestStreamId)id, discoveryService));
    }

    private <T, D, Y> Publisher<Y> combineWithLatestStream(CombineWithLatestStreamId<T, D, Y> streamId, DiscoveryService discoveryService) {
        Flowable data = Flowable.fromPublisher(discoveryService.discover(streamId.dataStream()));
        Flowable trigger = Flowable.fromPublisher(discoveryService.discover(streamId.triggerStream()));
        return trigger.withLatestFrom((Publisher)data, streamId.combiner()::apply);
    }
}

