/*
 * Decompiled with CFR 0.152.
 */
package cern.streaming.pool.core.service.streamfactory;

import cern.streaming.pool.core.service.CreatorProvidingService;
import cern.streaming.pool.core.service.DiscoveryService;
import cern.streaming.pool.core.service.StreamCreator;
import cern.streaming.pool.core.service.StreamFactory;
import cern.streaming.pool.core.service.StreamId;
import cern.streaming.pool.core.service.impl.IdentifiedStreamCreator;
import io.reactivex.Flowable;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.reactivestreams.Publisher;

public class CreatorStreamFactory
implements CreatorProvidingService,
StreamFactory {
    private final ConcurrentMap<StreamId<?>, StreamCreator<?>> suppliers = new ConcurrentHashMap();

    public CreatorStreamFactory(Iterable<IdentifiedStreamCreator<?>> identifiedCreators) {
        Objects.requireNonNull(identifiedCreators, "identifiedStreamCreators must not be null.");
        identifiedCreators.forEach(this::register);
    }

    @Override
    public <T> Optional<Publisher<T>> create(StreamId<T> newId, DiscoveryService discoveryService) {
        StreamCreator streamCreator = (StreamCreator)this.suppliers.get(newId);
        if (streamCreator == null) {
            return Optional.empty();
        }
        return Optional.of((Flowable)streamCreator.createWith(discoveryService));
    }

    @Override
    public <T> void provide(StreamId<T> id, StreamCreator<T> streamSupplier) {
        Objects.requireNonNull(id, "id must not be null!");
        Objects.requireNonNull(streamSupplier, "stream suplier must not be null!");
        StreamCreator<T> existingCreator = this.suppliers.putIfAbsent(id, streamSupplier);
        if (existingCreator != null) {
            throw new IllegalArgumentException("Id " + id + " already registered! Cannot register twice.");
        }
    }

    private <T> void register(IdentifiedStreamCreator<T> identifiedCreator) {
        this.suppliers.put(identifiedCreator.getId(), identifiedCreator.getCreator());
    }
}

