/*
 * Decompiled with CFR 0.152.
 */
package cern.streaming.pool.core.service.streamfactory;

import cern.streaming.pool.core.service.DiscoveryService;
import cern.streaming.pool.core.service.StreamFactory;
import cern.streaming.pool.core.service.StreamId;
import cern.streaming.pool.core.service.streamid.DelayedStreamId;
import io.reactivex.Flowable;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;

public class DelayedStreamFactory
implements StreamFactory {
    public <Y> Optional<Publisher<Y>> create(StreamId<Y> id, DiscoveryService discoveryService) {
        if (!(id instanceof DelayedStreamId)) {
            return Optional.empty();
        }
        DelayedStreamId delayedId = (DelayedStreamId)id;
        Duration delay = delayedId.getDelay();
        StreamId target = delayedId.getTarget();
        return Optional.of(Flowable.fromPublisher(discoveryService.discover(target)).delay(delay.toMillis(), TimeUnit.MILLISECONDS));
    }
}

