/*
 * Decompiled with CFR 0.152.
 */
package cern.streaming.pool.core.service.streamfactory;

import cern.streaming.pool.core.service.DiscoveryService;
import cern.streaming.pool.core.service.StreamFactory;
import cern.streaming.pool.core.service.StreamId;
import cern.streaming.pool.core.service.streamid.FilteredStreamId;
import io.reactivex.Flowable;
import java.util.Optional;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;

public class FilteredStreamFactory
implements StreamFactory {
    @Override
    public <T> Optional<Publisher<T>> create(StreamId<T> id, DiscoveryService discoveryService) {
        if (!(id instanceof FilteredStreamId)) {
            return Optional.empty();
        }
        FilteredStreamId filteredId = (FilteredStreamId)id;
        StreamId source = filteredId.sourceStreamId();
        Predicate predicate = filteredId.predicate();
        return Optional.of(Flowable.fromPublisher(discoveryService.discover(source)).filter(predicate::test));
    }
}

