/*
 * Decompiled with CFR 0.152.
 */
package cern.streaming.pool.core.service.streamid;

import cern.streaming.pool.core.service.StreamId;
import java.util.Objects;
import java.util.function.BiFunction;

public class CombineWithLatestStreamId<T, D, R>
implements StreamId<R> {
    private final StreamId<T> trigger;
    private final StreamId<D> data;
    private final BiFunction<T, D, R> combiner;

    private CombineWithLatestStreamId(StreamId<T> trigger, StreamId<D> data, BiFunction<T, D, R> combiner) {
        this.data = Objects.requireNonNull(data, "data stream must not be null");
        this.trigger = Objects.requireNonNull(trigger, "trigger stream must not be null");
        this.combiner = Objects.requireNonNull(combiner, "combiner must not be null");
    }

    public static <T, D> CombineWithLatestStreamId<T, D, D> dataPropagated(StreamId<T> trigger, StreamId<D> data) {
        return CombineWithLatestStreamId.combine(trigger, data, (t, d) -> d);
    }

    public static <T, D, R> CombineWithLatestStreamId<T, D, R> combine(StreamId<T> trigger, StreamId<D> data, BiFunction<T, D, R> combiner) {
        return new CombineWithLatestStreamId<T, D, R>(trigger, data, combiner);
    }

    public StreamId<D> dataStream() {
        return this.data;
    }

    public StreamId<T> triggerStream() {
        return this.trigger;
    }

    public BiFunction<T, D, R> combiner() {
        return this.combiner;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        result = 31 * result + (this.trigger == null ? 0 : this.trigger.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CombineWithLatestStreamId other = (CombineWithLatestStreamId)obj;
        if (this.data == null ? other.data != null : !this.data.equals(other.data)) {
            return false;
        }
        return !(this.trigger == null ? other.trigger != null : !this.trigger.equals(other.trigger));
    }

    public String toString() {
        return "CombineWithLatestStreamId [trigger=" + this.trigger + ", data=" + this.data + "]";
    }
}

