/*
 * Decompiled with CFR 0.152.
 */
package cern.streaming.pool.core.service.streamid;

import cern.streaming.pool.core.service.StreamId;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.reactivestreams.Publisher;

public final class CompositionStreamId<X, T>
implements StreamId<T> {
    private final List<StreamId<X>> sourceStreamIds;
    private final Function<List<Publisher<X>>, Publisher<T>> transformation;

    public CompositionStreamId(StreamId<X> sourceStreamId, Function<List<Publisher<X>>, Publisher<T>> transformation) {
        this(Collections.singletonList(sourceStreamId), transformation);
    }

    public CompositionStreamId(List<StreamId<X>> sourceStreamIds, Function<List<Publisher<X>>, Publisher<T>> transformation) {
        this.sourceStreamIds = sourceStreamIds;
        this.transformation = transformation;
    }

    public List<StreamId<X>> sourceStreamIds() {
        return this.sourceStreamIds;
    }

    public Function<List<Publisher<X>>, Publisher<T>> transformation() {
        return this.transformation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositionStreamId that = (CompositionStreamId)o;
        if (this.sourceStreamIds != null ? !this.sourceStreamIds.equals(that.sourceStreamIds) : that.sourceStreamIds != null) {
            return false;
        }
        return this.transformation != null ? this.transformation.equals(that.transformation) : that.transformation == null;
    }

    public int hashCode() {
        int result = this.sourceStreamIds != null ? this.sourceStreamIds.hashCode() : 0;
        result = 31 * result + (this.transformation != null ? this.transformation.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "CompositionStreamId{sourceStreamIds=" + this.sourceStreamIds + ", transformation=" + this.transformation + '}';
    }
}

