/*
 * Decompiled with CFR 0.152.
 */
package cern.streaming.pool.core.service.streamid;

import cern.streaming.pool.core.service.StreamId;
import java.util.Objects;
import java.util.function.Function;

public class DerivedStreamId<S, T>
implements StreamId<T> {
    private final StreamId<S> sourceStreamId;
    private final Function<S, T> conversion;

    public static <S, T> DerivedStreamId<S, T> derive(StreamId<S> sourceStreamId, Function<S, T> conversion) {
        return new DerivedStreamId<S, T>(sourceStreamId, conversion);
    }

    public DerivedStreamId(StreamId<S> sourceStreamId, Function<S, T> conversion) {
        this.sourceStreamId = Objects.requireNonNull(sourceStreamId, "sourceStreamId must not be null");
        this.conversion = Objects.requireNonNull(conversion, "conversion must not be null");
    }

    public StreamId<S> sourceStreamId() {
        return this.sourceStreamId;
    }

    public Function<S, T> conversion() {
        return this.conversion;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.conversion == null ? 0 : this.conversion.hashCode());
        result = 31 * result + (this.sourceStreamId == null ? 0 : this.sourceStreamId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DerivedStreamId other = (DerivedStreamId)obj;
        if (this.conversion == null ? other.conversion != null : !this.conversion.equals(other.conversion)) {
            return false;
        }
        return !(this.sourceStreamId == null ? other.sourceStreamId != null : !this.sourceStreamId.equals(other.sourceStreamId));
    }

    public String toString() {
        return "SimpleDerivedStreamId [sourceStreamId=" + this.sourceStreamId + ", conversion=" + this.conversion + "]";
    }
}

