/*
 * Decompiled with CFR 0.152.
 */
package cern.streaming.pool.core.service.streamid;

import cern.streaming.pool.core.service.StreamId;
import java.util.Objects;
import java.util.function.Predicate;

public class FilteredStreamId<T>
implements StreamId<T> {
    private final StreamId<T> sourceStreamId;
    private final Predicate<T> predicate;

    public static <T> FilteredStreamId<T> filterBy(StreamId<T> source, Predicate<T> predicate) {
        return new FilteredStreamId<T>(source, predicate);
    }

    public FilteredStreamId(StreamId<T> source, Predicate<T> predicate) {
        this.sourceStreamId = Objects.requireNonNull(source, "source of the filtering must not be null");
        this.predicate = Objects.requireNonNull(predicate, "predicate of the filtering must not be null");
    }

    public StreamId<T> sourceStreamId() {
        return this.sourceStreamId;
    }

    public Predicate<T> predicate() {
        return this.predicate;
    }

    public String toString() {
        return "FilteredStreamId [sourceStreamId=" + this.sourceStreamId + ", predicate=" + this.predicate + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.predicate == null ? 0 : this.predicate.hashCode());
        result = 31 * result + (this.sourceStreamId == null ? 0 : this.sourceStreamId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FilteredStreamId other = (FilteredStreamId)obj;
        if (this.predicate == null ? other.predicate != null : !this.predicate.equals(other.predicate)) {
            return false;
        }
        return !(this.sourceStreamId == null ? other.sourceStreamId != null : !this.sourceStreamId.equals(other.sourceStreamId));
    }
}

