/*
 * Decompiled with CFR 0.152.
 */
package cern.streaming.pool.core.service.streamid.factory.function;

import io.reactivex.Flowable;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.reactivestreams.Publisher;

public class DelayCompositionFunction<X>
implements Function<List<Publisher<X>>, Publisher<X>> {
    private final Duration duration;

    public DelayCompositionFunction(Duration duration) {
        Objects.requireNonNull(duration, "duration");
        this.duration = duration;
    }

    @Override
    public Publisher<X> apply(List<Publisher<X>> reactiveStreams) {
        return Flowable.fromPublisher(reactiveStreams.get(0)).delay(this.duration.toMillis(), TimeUnit.MILLISECONDS);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DelayCompositionFunction that = (DelayCompositionFunction)o;
        return this.duration.equals(that.duration);
    }

    public int hashCode() {
        return this.duration.hashCode();
    }
}

