/*
 * Decompiled with CFR 0.152.
 */
package cern.streaming.pool.core.service.streamid.factory.function;

import io.reactivex.Flowable;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;

public class FilterCompositionFunction<X>
implements Function<List<Publisher<X>>, Publisher<X>> {
    private final Predicate<X> predicate;

    public FilterCompositionFunction(Predicate<X> predicate) {
        Objects.requireNonNull(predicate, "predicate");
        this.predicate = predicate;
    }

    @Override
    public Publisher<X> apply(List<Publisher<X>> reactiveStreams) {
        return Flowable.fromPublisher(reactiveStreams.get(0)).filter(this.predicate::test);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterCompositionFunction that = (FilterCompositionFunction)o;
        return this.predicate.equals(that.predicate);
    }

    public int hashCode() {
        return this.predicate.hashCode();
    }
}

