/*
 * Decompiled with CFR 0.152.
 */
package cern.streaming.pool.core.service.streamid.factory.function;

import io.reactivex.Flowable;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.reactivestreams.Publisher;

public class FlatMapCompositionFunction<X, T>
implements Function<List<Publisher<X>>, Publisher<T>> {
    private final Function<X, Publisher<T>> flatMapConversion;

    public FlatMapCompositionFunction(Function<X, Publisher<T>> flatMapConversion) {
        Objects.requireNonNull(flatMapConversion);
        this.flatMapConversion = flatMapConversion;
    }

    @Override
    public Publisher<T> apply(List<Publisher<X>> reactiveStreams) {
        return Flowable.fromPublisher(reactiveStreams.get(0)).flatMap(this.flatMapConversion::apply);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlatMapCompositionFunction that = (FlatMapCompositionFunction)o;
        return this.flatMapConversion.equals(that.flatMapConversion);
    }

    public int hashCode() {
        return this.flatMapConversion.hashCode();
    }
}

