/*
 * Decompiled with CFR 0.152.
 */
package cern.streaming.pool.core.service.util;

import cern.streaming.pool.core.service.StreamCreator;
import cern.streaming.pool.core.service.StreamId;
import cern.streaming.pool.core.service.impl.IdentifiedStreamCreator;
import cern.streaming.pool.core.service.impl.ImmutableIdentifiedStreamCreator;
import java.util.Objects;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;

public final class StreamCreators {
    private StreamCreators() {
    }

    public static <T> OngoingCreatorCreation<T> create(StreamCreator<T> creator) {
        return new OngoingCreatorCreation<T>(creator);
    }

    public static <T> OngoingCreatorCreation<T> create(Supplier<Publisher<T>> supplier) {
        return new OngoingCreatorCreation(discovery -> (Publisher)supplier.get());
    }

    public static class OngoingCreatorCreation<T> {
        private final StreamCreator<T> streamCreator;

        public OngoingCreatorCreation(StreamCreator<T> streamCreator) {
            this.streamCreator = Objects.requireNonNull(streamCreator, "streamCreator must not be null.");
        }

        public IdentifiedStreamCreator<T> as(StreamId<T> streamId) {
            return ImmutableIdentifiedStreamCreator.of(streamId, this.streamCreator);
        }
    }
}

