/*
 * Decompiled with CFR 0.152.
 */
package cern.streaming.pool.core.support;

import cern.streaming.pool.core.service.CreatorProvidingService;
import cern.streaming.pool.core.service.DiscoveryService;
import cern.streaming.pool.core.service.ProvidingService;
import cern.streaming.pool.core.service.StreamCreator;
import cern.streaming.pool.core.service.StreamId;
import cern.streaming.pool.core.support.StreamSupport;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;

public class AbstractStreamSupport
implements StreamSupport {
    @Autowired
    private DiscoveryService discoveryService;
    @Autowired
    private ProvidingService providingService;
    @Autowired
    private CreatorProvidingService lazyProvidingService;

    @Override
    public <T> Publisher<T> discover(StreamId<T> id) {
        return this.discoveryService.discover(id);
    }

    @Override
    public <T> StreamSupport.OngoingProviding<T> provide(Publisher<T> reactStream) {
        return new StreamSupport.OngoingProviding<T>(this.providingService, reactStream);
    }

    @Override
    public <T> StreamSupport.OngoingLazyProviding<T> provide(StreamCreator<T> reactStream) {
        return new StreamSupport.OngoingLazyProviding<T>(this.lazyProvidingService, reactStream);
    }

    @Override
    public ProvidingService providingService() {
        return this.providingService;
    }
}

