/*
 * Decompiled with CFR 0.152.
 */
package cern.streaming.pool.core.support;

import cern.streaming.pool.core.service.StreamId;
import cern.streaming.pool.core.service.rx.RxStreams;
import cern.streaming.pool.core.support.RxStreamSupport;
import java.util.Objects;

public interface StreamCollectingSupport
extends RxStreamSupport {
    default public <T> OngoingBlockingCollecting<T> from(StreamId<T> streamId) {
        return new OngoingBlockingCollecting(streamId, this);
    }

    public static class OngoingBlockingCollecting<T> {
        private int skip = 0;
        private final StreamId<T> streamId;
        private final RxStreamSupport support;

        private OngoingBlockingCollecting(StreamId<T> streamId, RxStreamSupport support) {
            this.support = Objects.requireNonNull(support, "RxStreamSupport must not be null");
            this.streamId = Objects.requireNonNull(streamId, "streamId must not be null");
            if (this.skip < 0) {
                throw new IllegalArgumentException("The number of acquisitions to skip must be >=0, but was " + this.skip + ".");
            }
        }

        public OngoingBlockingCollecting<T> skip(int itemsToSkip) {
            this.skip = itemsToSkip;
            return this;
        }

        public OngoingBlockingCollecting<T> and() {
            return this;
        }

        public T awaitNext() {
            return RxStreams.awaitNext(this.support.rxFrom(this.streamId).skip((long)this.skip));
        }
    }
}

