/*
 * Decompiled with CFR 0.152.
 */
package cern.streaming.pool.core.support;

import cern.streaming.pool.core.service.CreatorProvidingService;
import cern.streaming.pool.core.service.ProvidingService;
import cern.streaming.pool.core.service.StreamCreator;
import cern.streaming.pool.core.service.StreamId;
import org.reactivestreams.Publisher;

public interface StreamSupport {
    public <T> Publisher<T> discover(StreamId<T> var1);

    public <T> OngoingProviding<T> provide(Publisher<T> var1);

    public <T> OngoingLazyProviding<T> provide(StreamCreator<T> var1);

    public ProvidingService providingService();

    public static class OngoingLazyProviding<T> {
        private final StreamCreator<T> reactStream;
        private final CreatorProvidingService providingService;

        public OngoingLazyProviding(CreatorProvidingService providingService, StreamCreator<T> reactStream) {
            this.providingService = providingService;
            this.reactStream = reactStream;
        }

        public void as(StreamId<T> id) {
            this.providingService.provide(id, this.reactStream);
        }
    }

    public static class OngoingProviding<T> {
        private final Publisher<T> reactStream;
        private final ProvidingService providingService;

        public OngoingProviding(ProvidingService providingService, Publisher<T> reactStream) {
            this.providingService = providingService;
            this.reactStream = reactStream;
        }

        public void as(StreamId<T> id) {
            this.providingService.provide(id, this.reactStream);
        }

        public StreamId<T> withUniqueStreamId() {
            StreamId<T> uniqueStreamId = OngoingProviding.generateUniqueId();
            this.as(uniqueStreamId);
            return uniqueStreamId;
        }

        private static <T> StreamId<T> generateUniqueId() {
            return new StreamId<T>(){

                public String toString() {
                    return "Generated unique StreamId from StreamSupport";
                }
            };
        }
    }
}

