/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.core.service.impl;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.streamingpool.core.service.DiscoveryService;
import org.streamingpool.core.service.ProvidingService;
import org.streamingpool.core.service.StreamFactory;
import org.streamingpool.core.service.StreamId;
import org.streamingpool.core.service.impl.PoolContent;
import org.streamingpool.core.service.impl.TrackKeepingDiscoveryService;

public class LocalPool
implements DiscoveryService,
ProvidingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalPool.class);
    private final List<StreamFactory> factories;
    private final PoolContent content = new PoolContent();

    public LocalPool() {
        this((List<StreamFactory>)ImmutableList.of());
    }

    public LocalPool(List<StreamFactory> factories) {
        this.factories = ImmutableList.copyOf(factories);
        LOGGER.info("Available Stream Factories: " + factories);
    }

    @Override
    public <T> void provide(StreamId<T> id, Publisher<T> obs) {
        Objects.requireNonNull(id, "id must not be null!");
        Objects.requireNonNull(obs, "stream must not be null!");
        boolean inserted = this.content.synchronousPutIfAbsent(id, () -> obs);
        if (!inserted) {
            throw new IllegalArgumentException("Id " + id + " already registered! Cannot register twice.");
        }
    }

    @Override
    public <T> Publisher<T> discover(StreamId<T> id) {
        Objects.requireNonNull(id, "Cannot discover a null id");
        return new TrackKeepingDiscoveryService(this.factories, this.content).discover(id);
    }
}

