/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.core.service.streamfactory;

import io.reactivex.Flowable;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.streamingpool.core.service.DiscoveryService;
import org.streamingpool.core.service.StreamFactory;
import org.streamingpool.core.service.StreamId;
import org.streamingpool.core.service.streamid.CombineWithLatestStreamId;

public class CombineWithLatestStreamFactory
implements StreamFactory {
    public <Y> Optional<Publisher<Y>> create(StreamId<Y> id, DiscoveryService discoveryService) {
        if (!(id instanceof CombineWithLatestStreamId)) {
            return Optional.empty();
        }
        return Optional.of(this.combineWithLatestStream((CombineWithLatestStreamId)id, discoveryService));
    }

    private <T, D, Y> Publisher<Y> combineWithLatestStream(CombineWithLatestStreamId<T, D, Y> streamId, DiscoveryService discoveryService) {
        Flowable data = Flowable.fromPublisher(discoveryService.discover(streamId.dataStream()));
        Flowable trigger = Flowable.fromPublisher(discoveryService.discover(streamId.triggerStream()));
        return trigger.withLatestFrom((Publisher)data, streamId.combiner()::apply);
    }
}

