/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.core.service.streamfactory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.streamingpool.core.service.DiscoveryService;
import org.streamingpool.core.service.StreamFactory;
import org.streamingpool.core.service.StreamId;
import org.streamingpool.core.service.streamid.CompositionStreamId;

public final class CompositionStreamFactory
implements StreamFactory {
    @Override
    public <T> Optional<Publisher<T>> create(StreamId<T> id, DiscoveryService discoveryService) {
        Objects.requireNonNull(discoveryService, "discoveryService");
        if (!(id instanceof CompositionStreamId)) {
            return Optional.empty();
        }
        CompositionStreamId compositionStreamId = (CompositionStreamId)id;
        return Optional.of(this.createStream(compositionStreamId, discoveryService));
    }

    private <X, T> Publisher<T> createStream(CompositionStreamId<X, T> id, DiscoveryService discoveryService) {
        List<Publisher<X>> extractedStreams = this.extractStreams(id.sourceStreamIds(), discoveryService);
        return id.transformation().apply(extractedStreams);
    }

    private <X> List<Publisher<X>> extractStreams(Collection<StreamId<X>> streamIds, DiscoveryService discoveryService) {
        ArrayList<Publisher<X>> sourceReactiveStreams = new ArrayList<Publisher<X>>();
        for (StreamId<X> streamId : streamIds) {
            sourceReactiveStreams.add(discoveryService.discover(streamId));
        }
        return sourceReactiveStreams;
    }
}

