/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.core.service.streamfactory;

import io.reactivex.Flowable;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;
import org.streamingpool.core.service.DiscoveryService;
import org.streamingpool.core.service.StreamFactory;
import org.streamingpool.core.service.StreamId;
import org.streamingpool.core.service.streamid.DelayedStreamId;

public class DelayedStreamFactory
implements StreamFactory {
    public <Y> Optional<Publisher<Y>> create(StreamId<Y> id, DiscoveryService discoveryService) {
        if (!(id instanceof DelayedStreamId)) {
            return Optional.empty();
        }
        DelayedStreamId delayedId = (DelayedStreamId)id;
        Duration delay = delayedId.getDelay();
        StreamId target = delayedId.getTarget();
        return Optional.of(Flowable.fromPublisher(discoveryService.discover(target)).delay(delay.toMillis(), TimeUnit.MILLISECONDS));
    }
}

