/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.core.service.streamfactory;

import io.reactivex.Flowable;
import java.util.Optional;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import org.streamingpool.core.service.DiscoveryService;
import org.streamingpool.core.service.StreamFactory;
import org.streamingpool.core.service.StreamId;
import org.streamingpool.core.service.streamid.FilteredStreamId;

public class FilteredStreamFactory
implements StreamFactory {
    @Override
    public <T> Optional<Publisher<T>> create(StreamId<T> id, DiscoveryService discoveryService) {
        if (!(id instanceof FilteredStreamId)) {
            return Optional.empty();
        }
        FilteredStreamId filteredId = (FilteredStreamId)id;
        StreamId source = filteredId.sourceStreamId();
        Predicate predicate = filteredId.predicate();
        return Optional.of(Flowable.fromPublisher(discoveryService.discover(source)).filter(predicate::test));
    }
}

