/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.core.domain;

import java.time.Instant;
import java.util.Objects;

public class Timestamped<T> {
    private final T value;
    private final Instant instant;

    private Timestamped(Instant instant, T value) {
        this.value = Objects.requireNonNull(value, "value must not be null");
        this.instant = Objects.requireNonNull(instant, "instant must not be null");
    }

    public static <T> Timestamped<T> atOf(Instant instant, T value) {
        return new Timestamped<T>(instant, value);
    }

    public static <T> Timestamped<T> nowOf(T value) {
        return Timestamped.atOf(Instant.now(), value);
    }

    public T value() {
        return this.value;
    }

    public Instant instant() {
        return this.instant;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.instant == null ? 0 : this.instant.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Timestamped other = (Timestamped)obj;
        if (this.instant == null ? other.instant != null : !this.instant.equals(other.instant)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return this.value + "@" + this.instant;
    }
}

