/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.core.names.resolve;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

public final class Chains {
    private Chains() {
    }

    public static <R> ChainBuilder<Object, R, Function<Object, R>> chain() {
        return Chains.newFunctionBuilder();
    }

    public static <R> ChainBuilder<Object, R, Function<Object, R>> chain(BiFunction<Object, Function<Object, R>, R> mapperWithCallback) {
        ChainBuilder<Object, R, Function<Object, R>> builder = Chains.newFunctionBuilder();
        return (ChainBuilder)builder.or(mapperWithCallback);
    }

    private static <R> ChainBuilder<Object, R, Function<Object, R>> newFunctionBuilder() {
        return new ChainBuilder(b -> new Chain(new BranchChain(b)));
    }

    private static <T, R> ChainBuilder<T, R, BiFunction<T, Function<? super T, R>, R>> newBiFunctionBuilder() {
        return new ChainBuilder(BranchChain::new);
    }

    private static final class ConditionedMapper<T, T1 extends T, R>
    implements BiFunction<T, Function<? super T1, R>, R> {
        private final Predicate<T> condition;
        private final BiFunction<? super T1, ? extends Function<? super T1, R>, R> mapper;
        private final Function<T, T1> conversion;

        public ConditionedMapper(Predicate<T> condition, Function<T, T1> conversion, BiFunction<? super T1, ? extends Function<? super T1, R>, R> mapper) {
            this.condition = Objects.requireNonNull(condition, "condition must not be null");
            this.conversion = Objects.requireNonNull(conversion, "conversion must not be null");
            this.mapper = Objects.requireNonNull(mapper, "mapper must not be null");
        }

        public ConditionedMapper(Predicate<T> condition, Function<T, T1> conversion, Function<T1, R> mapper) {
            this(condition, conversion, (? super T1 o, ? extends Function<? super T1, R> c) -> Objects.requireNonNull(mapper, "mapper must not be null").apply(o));
        }

        public Predicate<T> condition() {
            return this.condition;
        }

        @Override
        public R apply(T input, Function<? super T1, R> callback) {
            T1 converted = this.conversion.apply(input);
            return this.mapper().apply(converted, callback);
        }

        private BiFunction<? super T1, Function<? super T1, R>, R> mapper() {
            return this.mapper;
        }
    }

    private static final class Chain<R>
    implements Function<Object, R> {
        private final BiFunction<Object, Function<? super Object, R>, R> delegate;

        public Chain(BiFunction<Object, Function<? super Object, R>, R> delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate must not be null");
        }

        @Override
        public R apply(Object input) {
            return this.delegate.apply(input, this);
        }
    }

    private static final class BranchChain<T, R>
    implements BiFunction<T, Function<? super T, R>, R> {
        private final List<ConditionedMapper<T, ?, R>> conditionedMappers;
        private final R defaultValue;
        private final boolean throwIfAllReturnNull;
        private final Predicate<R> returnWhen;

        BranchChain(ChainBuilder<T, R, ?> builder) {
            this.conditionedMappers = builder.mappers.build();
            this.returnWhen = builder.returnWhen;
            this.defaultValue = builder.defaultValue;
            this.throwIfAllReturnNull = builder.throwIfAllReturnNull;
        }

        @Override
        public R apply(T input, Function<? super T, R> callback) {
            Objects.requireNonNull(input, "input value to chained functions must not be null.");
            for (ConditionedMapper<T, ?, R> conditionedMapper : this.conditionedMappers) {
                R returnValue;
                if (!conditionedMapper.condition().test(input) || !this.returnWhen.test(returnValue = conditionedMapper.apply(input, callback))) continue;
                return returnValue;
            }
            if (this.throwIfAllReturnNull) {
                throw new IllegalArgumentException("None of the chained functions returned a non-null value for input value '" + input + "'.");
            }
            return this.defaultValue;
        }
    }

    public static class ChainBuilder<T, R, F>
    extends AbstractBuilder<T, R, ChainBuilder<T, R, F>> {
        private final Function<ChainBuilder<T, R, F>, ? extends F> constructor;

        ChainBuilder(Function<ChainBuilder<T, R, F>, ? extends F> constructor) {
            this.constructor = constructor;
        }

        public F orElseThrow() {
            this.defaultValue = null;
            this.throwIfAllReturnNull = true;
            return this.constructor.apply(this);
        }

        public F orElseNull() {
            this.defaultValue = null;
            this.throwIfAllReturnNull = false;
            return this.constructor.apply(this);
        }

        public F orElse(R newDefaultValue) {
            this.defaultValue = newDefaultValue;
            this.throwIfAllReturnNull = false;
            return this.constructor.apply(this);
        }
    }

    public static class BiFunctionBranchBuilder<PT, T extends PT, R, PB extends AbstractBuilder<PT, R, PB>>
    extends AbstractBranchBuilder<PT, T, R, ChainBuilder<T, R, BiFunction<T, Function<? super T, R>, R>>, PB, BiFunctionBranchBuilder<PT, T, R, PB>> {
        BiFunctionBranchBuilder(Predicate<PT> condition, Function<PT, T> conversion, ChainBuilder<T, R, BiFunction<T, Function<? super T, R>, R>> delegate, PB parentBuilder) {
            super(condition, conversion, delegate, parentBuilder);
        }

        public PB orElseThrow() {
            return (PB)this.parentBuilder.when(this.condition, this.conversion, (BiFunction)((ChainBuilder)this.delegate).orElseThrow());
        }

        public PB orElseNull() {
            return (PB)this.parentBuilder.when(this.condition, this.conversion, (BiFunction)((ChainBuilder)this.delegate).orElseNull());
        }

        public PB orElse(R newDefaultValue) {
            return (PB)this.parentBuilder.when(this.condition, this.conversion, (BiFunction)((ChainBuilder)this.delegate).orElse(newDefaultValue));
        }
    }

    public static class FunctionBranchBuilder<PT, T extends PT, R, PB extends AbstractBuilder<PT, R, PB>>
    extends AbstractBranchBuilder<PT, T, R, ChainBuilder<T, R, Function<T, R>>, PB, FunctionBranchBuilder<PT, T, R, PB>> {
        FunctionBranchBuilder(Predicate<PT> condition, Function<PT, T> conversion, ChainBuilder<T, R, Function<T, R>> delegate, PB parentBuilder) {
            super(condition, conversion, delegate, parentBuilder);
        }

        public PB orElseThrow() {
            return (PB)this.parentBuilder.when(this.condition, this.conversion, (Function)((ChainBuilder)this.delegate).orElseThrow());
        }

        public PB orElseNull() {
            return (PB)this.parentBuilder.when(this.condition, this.conversion, (Function)((ChainBuilder)this.delegate).orElseNull());
        }

        public PB orElse(R newDefaultValue) {
            return (PB)this.parentBuilder.when(this.condition, this.conversion, (Function)((ChainBuilder)this.delegate).orElse(newDefaultValue));
        }
    }

    public static abstract class AbstractBranchBuilder<PT, T extends PT, R, B extends AbstractBuilder<T, R, B>, PB extends AbstractBuilder<PT, R, PB>, BB extends AbstractBranchBuilder<PT, T, R, B, PB, BB>> {
        final B delegate;
        final PB parentBuilder;
        final Predicate<PT> condition;
        final Function<PT, T> conversion;
        private BB castedThis = this;

        AbstractBranchBuilder(Predicate<PT> condition, Function<PT, T> conversion, B delegate, PB parentBuilder) {
            this.condition = Objects.requireNonNull(condition, "condition must not be null");
            this.conversion = Objects.requireNonNull(conversion, "conversion must not be null");
            this.delegate = (AbstractBuilder)Objects.requireNonNull(delegate, "delegate must not be null");
            this.parentBuilder = (AbstractBuilder)Objects.requireNonNull(parentBuilder, "parentBuilder must not be null");
        }

        public BB or(Function<? super T, R> mapper) {
            ((AbstractBuilder)this.delegate).or(mapper);
            return this.castedThis;
        }

        public BB or(BiFunction<? super T, ? extends Function<Object, R>, R> mapperWithCallback) {
            ((AbstractBuilder)this.delegate).or(mapperWithCallback);
            return this.castedThis;
        }

        public BB breakOnFirst(Predicate<R> newReturnWhen) {
            ((AbstractBuilder)this.delegate).breakOnFirst(newReturnWhen);
            return this.castedThis;
        }

        public <T1 extends T> BB when(Predicate<T> newCondition, Function<T, T1> conv, BiFunction<T1, Function<? super T1, R>, R> mapperWithCallback) {
            ((AbstractBuilder)this.delegate).when(newCondition, conv, mapperWithCallback);
            return this.castedThis;
        }

        public <T1 extends T> BB when(Predicate<T> newCondition, Function<T, T1> conv, Function<T1, R> mapper) {
            ((AbstractBuilder)this.delegate).when(newCondition, conv, mapper);
            return this.castedThis;
        }
    }

    private static abstract class AbstractBuilder<T, R, B extends AbstractBuilder<T, R, B>> {
        final ImmutableList.Builder<ConditionedMapper<T, ?, R>> mappers = ImmutableList.builder();
        Predicate<R> returnWhen = v -> v != null;
        boolean throwIfAllReturnNull;
        R defaultValue;
        B castedThis = this;

        private AbstractBuilder() {
        }

        public B or(Function<? super T, R> mapper) {
            Objects.requireNonNull(mapper, "new mapper must not be null");
            this.or((? super T o, ? extends Function<? super T, R> c) -> mapper.apply(o));
            return this.castedThis;
        }

        public B or(BiFunction<? super T, ? extends Function<? super T, R>, R> mapperWithCallback) {
            Objects.requireNonNull(mapperWithCallback, "new mapper must not be null");
            this.mappers.add(new ConditionedMapper<Object, T, R>(o -> true, Function.identity(), mapperWithCallback));
            return this.castedThis;
        }

        public B breakOnFirst(Predicate<R> newReturnWhen) {
            this.returnWhen = Objects.requireNonNull(newReturnWhen, "predicate to break must not be null");
            return this.castedThis;
        }

        public BiFunctionBranchBuilder<T, T, R, B> branchIf(Predicate<T> condition, Function<T, R> mapper) {
            return (BiFunctionBranchBuilder)this.newBranchBuilder(condition).or(mapper);
        }

        public BiFunctionBranchBuilder<T, T, R, B> branchIf(Predicate<T> condition, BiFunction<T, ? extends Function<Object, R>, R> mapper) {
            return (BiFunctionBranchBuilder)this.newBranchBuilder(condition).or(mapper);
        }

        private BiFunctionBranchBuilder<T, T, R, B> newBranchBuilder(Predicate<T> condition) {
            return new BiFunctionBranchBuilder(condition, Function.identity(), Chains.newBiFunctionBuilder(), this.castedThis);
        }

        public <T1 extends T> BiFunctionBranchBuilder<T, T1, R, B> branchCase(Class<T1> caseClass, Function<? super T1, R> mapper) {
            return (BiFunctionBranchBuilder)new BiFunctionBranchBuilder<Object, Object, R, B>(caseClass::isInstance, caseClass::cast, Chains.newBiFunctionBuilder(), this.castedThis).or(mapper);
        }

        public <T1 extends T> BiFunctionBranchBuilder<T, T1, R, B> branchCase(Class<T1> condition, BiFunction<? super T1, ? extends Function<Object, R>, R> mapper) {
            return (BiFunctionBranchBuilder)new BiFunctionBranchBuilder<Object, Object, R, B>(condition::isInstance, condition::cast, Chains.newBiFunctionBuilder(), this.castedThis).or(mapper);
        }

        public <T1 extends T> B when(Predicate<T> condition, Function<T, T1> conv, BiFunction<T1, Function<? super T1, R>, R> mapperWithCallback) {
            Objects.requireNonNull(condition, "condition must not be null");
            Objects.requireNonNull(mapperWithCallback, "mapper must not be null");
            this.mappers.add(new ConditionedMapper<T, T1, R>(condition, conv, mapperWithCallback));
            return this.castedThis;
        }

        public <T1 extends T> B when(Predicate<T> condition, Function<T, T1> conv, Function<T1, R> mapper) {
            Objects.requireNonNull(mapper, "mapper must not be null");
            this.when(condition, conv, (T1 o, Function<? super T1, R> c) -> mapper.apply(o));
            return this.castedThis;
        }
    }
}

