/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.core.support;

import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.streamingpool.core.service.CreatorProvidingService;
import org.streamingpool.core.service.DiscoveryService;
import org.streamingpool.core.service.ProvidingService;
import org.streamingpool.core.service.StreamCreator;
import org.streamingpool.core.service.StreamId;
import org.streamingpool.core.support.StreamSupport;

public class AbstractStreamSupport
implements StreamSupport {
    @Autowired
    private DiscoveryService discoveryService;
    @Autowired
    private ProvidingService providingService;
    @Autowired
    private CreatorProvidingService lazyProvidingService;

    @Override
    public <T> Publisher<T> discover(StreamId<T> id) {
        return this.discoveryService.discover(id);
    }

    @Override
    public <T> StreamSupport.OngoingProviding<T> provide(Publisher<T> reactStream) {
        return new StreamSupport.OngoingProviding<T>(this.providingService, reactStream);
    }

    @Override
    public <T> StreamSupport.OngoingLazyProviding<T> provide(StreamCreator<T> reactStream) {
        return new StreamSupport.OngoingLazyProviding<T>(this.lazyProvidingService, reactStream);
    }

    @Override
    public ProvidingService providingService() {
        return this.providingService;
    }
}

