/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.core.domain;

import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.subjects.PublishSubject;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import org.streamingpool.core.domain.ErrorStreamException;
import org.streamingpool.core.domain.ErrorStreamPair;

public final class ErrorDeflector {
    private final PublishSubject<Throwable> errorStream = PublishSubject.create();

    public static final ErrorDeflector create() {
        return new ErrorDeflector();
    }

    public <S, T> io.reactivex.functions.Function<S, Optional<T>> emptyOnError(Function<S, T> function) {
        return val -> {
            try {
                return Optional.of(function.apply(val));
            }
            catch (Exception e) {
                this.deflectOperationIncomingError(function, val, e);
                return Optional.empty();
            }
        };
    }

    public <T> io.reactivex.functions.Predicate<T> falseOnError(Predicate<T> predicate) {
        return it -> {
            try {
                return predicate.test(it);
            }
            catch (Exception e) {
                this.deflectOperationIncomingError(predicate, it, e);
                return false;
            }
        };
    }

    private <T> void deflectOperationIncomingError(Object operation, T incoming, Exception e) {
        ErrorStreamException exception = new ErrorStreamException("Error in operation " + operation + ". Incoming value: " + incoming, e);
        this.errorStream.onNext((Object)exception);
    }

    public <T> ErrorStreamPair<T> stream(Publisher<T> dataPublisher) {
        return ErrorStreamPair.ofDataError(dataPublisher, (Publisher<Throwable>)this.errorStream.toFlowable(BackpressureStrategy.DROP));
    }

    public <T> ErrorStreamPair<T> streamNonEmpty(Publisher<Optional<T>> optionalPublisher) {
        return this.stream((Publisher<T>)Flowable.fromPublisher(optionalPublisher).filter(Optional::isPresent).map(Optional::get));
    }
}

