/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.core.domain;

import java.time.Instant;
import java.util.Objects;

public class Timestamped<T> {
    private final T value;
    private final Instant time;

    private Timestamped(Instant instant, T value) {
        this.value = Objects.requireNonNull(value, "value must not be null");
        this.time = Objects.requireNonNull(instant, "instant must not be null");
    }

    public static <T> Timestamped<T> atOf(Instant instant, T value) {
        return new Timestamped<T>(instant, value);
    }

    public static <T> Timestamped<T> nowOf(T value) {
        return Timestamped.atOf(Instant.now(), value);
    }

    public T value() {
        return this.value;
    }

    public Instant instant() {
        return this.time;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.time == null ? 0 : this.time.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Timestamped other = (Timestamped)obj;
        if (this.time == null ? other.time != null : !this.time.equals(other.time)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return this.value + "@" + this.time;
    }
}

