/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.core.service.impl;

import io.reactivex.processors.PublishProcessor;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.streamingpool.core.domain.ErrorStreamPair;
import org.streamingpool.core.service.StreamId;
import org.streamingpool.core.service.diagnostic.ErrorStreamId;
import org.streamingpool.core.service.streamid.StreamingPoolHook;

public class PoolContent {
    private final ConcurrentMap<StreamId<?>, Publisher<?>> activeStreams = new ConcurrentHashMap();
    private final PublishProcessor<StreamId<?>> newStreamHook = PublishProcessor.create();
    private final ExecutorService hookExecutor = Executors.newSingleThreadExecutor();

    public PoolContent() {
        this.addStreamHooks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> boolean synchronousPutIfAbsent(StreamId<T> id, Supplier<ErrorStreamPair<T>> supplier) {
        if (!this.activeStreams.containsKey(id)) {
            ConcurrentMap<StreamId<?>, Publisher<?>> concurrentMap = this.activeStreams;
            synchronized (concurrentMap) {
                ErrorStreamPair<T> stream;
                if (!this.activeStreams.containsKey(id) && (stream = supplier.get()).isPresent()) {
                    ErrorStreamId errorStreamId = ErrorStreamId.of(id);
                    this.activeStreams.put(id, stream.data());
                    this.activeStreams.put(errorStreamId, stream.error());
                    this.hookExecutor.submit(() -> this.newStreamHook.onNext((Object)id));
                    this.hookExecutor.submit(() -> this.newStreamHook.onNext((Object)errorStreamId));
                    return true;
                }
            }
        }
        return false;
    }

    public <T> Publisher<T> get(StreamId<T> id) {
        return (Publisher)this.activeStreams.get(id);
    }

    private void addStreamHooks() {
        this.activeStreams.put(StreamingPoolHook.NEW_STREAM_HOOK, (Publisher<?>)this.newStreamHook);
    }
}

