/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.core.service.streamid.factory.function;

import io.reactivex.Flowable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.reactivestreams.Publisher;

public class MapCompositionFunction<X, T>
implements Function<List<Publisher<X>>, Publisher<T>> {
    private final Function<X, Optional<T>> mapFunction;

    public MapCompositionFunction(Function<X, Optional<T>> mapFunction) {
        Objects.requireNonNull(mapFunction, "mapFunction");
        this.mapFunction = mapFunction;
    }

    @Override
    public Publisher<T> apply(List<Publisher<X>> reactiveStreams) {
        return Flowable.fromPublisher(reactiveStreams.get(0)).map(this.mapFunction::apply).filter(Optional::isPresent).map(Optional::get);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapCompositionFunction that = (MapCompositionFunction)o;
        return this.mapFunction != null ? this.mapFunction.equals(that.mapFunction) : that.mapFunction == null;
    }

    public int hashCode() {
        return this.mapFunction != null ? this.mapFunction.hashCode() : 0;
    }
}

