/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.core.conf;

import io.reactivex.schedulers.Schedulers;
import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.streamingpool.core.conf.PoolConfiguration;

@Configuration
public class DefaultPoolConfiguration {
    public static final String STREAMINGPOOL_THREAD_POOL_SIZE = "streamingpool.threadPoolSize";
    public static final String STREAMINGPOOL_OBSERVE_ON_CAPACITY = "streamingpool.observeOnCapacity";
    @Value(value="${streamingpool.threadPoolSize:100}")
    private int threadPoolSize;
    @Value(value="${streamingpool.observeOnCapacity:128}")
    private int observeOnCapacity;

    @Bean
    @Conditional(value={NoTestSchedulerPresent.class})
    public PoolConfiguration localPoolConfiguration() {
        return new PoolConfiguration(Schedulers.from((Executor)Executors.newFixedThreadPool(this.threadPoolSize)), this.observeOnCapacity);
    }

    private static class NoTestSchedulerPresent
    implements Condition {
        private NoTestSchedulerPresent() {
        }

        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            Environment env = context.getEnvironment();
            return !Arrays.stream(env.getActiveProfiles()).anyMatch("streamingpool.test.scheduler"::equals);
        }
    }
}

